import 'package:admin_desktop/application/masters/accepted_masters/accepted_masters_provider.dart';
import 'package:admin_desktop/presentation/components/buttons/custom_refresher.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/schedule/widgets/components/status_modal.dart';
import 'package:admin_desktop/presentation/pages/main/widgets/schedule/widgets/list_view/booking_table.dart';
import 'package:admin_desktop/presentation/theme/theme/theme.dart';
import 'package:flutter_screenutil/flutter_screenutil.dart';
import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:remixicon_updated/remixicon_updated.dart';
import 'package:admin_desktop/application/bookings/booking_provider.dart';
import 'package:admin_desktop/infrastructure/services/utils.dart';
import 'package:admin_desktop/presentation/components/components.dart';
import 'package:admin_desktop/presentation/styles/style.dart';
import 'components/zoom_modal.dart';
import 'three_day_view/three_day_view.dart';
import 'package:flutter/material.dart';
import 'week_view/week_view.dart';
import 'day_view/day_view.dart';

class CalendarViewBody extends ConsumerWidget {
  final double? width;
  final CustomColorSet colors;

  const CalendarViewBody({
    super.key,
    this.width,
    required this.colors,
  });

  @override
  Widget build(BuildContext context, ref) {
    final state = ref.watch(bookingProvider);
    final notifier = ref.read(bookingProvider.notifier);
    return Column(
      children: [
        Container(
          decoration: BoxDecoration(color: Style.white),
          child: Row(
            children: [
              8.horizontalSpace,
              SizedBox(
                width: MediaQuery.sizeOf(context).width / 5,
                child: Text(
                  AppHelpers.getTranslation(TrKeys.schedule),
                  style: Style.interMedium(size: 20),
                ),
              ),
              Spacer(),
              IconButton(
                  onPressed: () {
                    notifier.openTopBar();
                  },
                  icon: !state.isOpen
                      ? Icon(
                          Icons.keyboard_arrow_down_sharp,
                          size: 30,
                        )
                      : Icon(
                          Icons.keyboard_arrow_up,
                          size: 30,
                        )),
              12.horizontalSpace,
            ],
          ),
        ),
        !state.isOpen
            ? SizedBox.shrink()
            : Container(
                decoration: BoxDecoration(color: Style.white),
                child: Row(
                  children: [
                    8.horizontalSpace,
                    Container(
                      width: 160,
                      margin: EdgeInsets.symmetric(vertical: 12),
                      padding: EdgeInsets.only(left: 8),
                      decoration: BoxDecoration(
                          color: Style.greyColor,
                          borderRadius: BorderRadius.circular(12)),
                      child: CustomDropdown(
                        hintText:
                            AppHelpers.getTranslation(TrKeys.selectMaster),
                        onChanged: (s) {
                          ref
                              .read(acceptedMastersProvider.notifier)
                              .setMastersQuery(context, s,);
                        },
                        dropDownType: DropDownType.masters,
                      ),
                    ),
                    20.horizontalSpace,
                    state.calendarType == 3
                        ? SizedBox.shrink()
                        : LoginButton(
                            height: 44,
                            title: state.status ?? TrKeys.selectStatus,
                            titleColor: state.status == null
                                ? Style.black
                                : Style.white,
                            bgColor: state.status == null
                                ? Style.greyColor
                                : AppHelpers.getStatusColor(state.status),
                            onPressed: () {
                              AppHelpers.showCustomDialog(
                                  context: context,
                                  title: TrKeys.status,
                                  child: StatusModal());
                            },
                          ),
                    Spacer(),
                    Padding(
                      padding: const EdgeInsets.all(12.0),
                      child: SizedBox(
                          height: 75,
                          child: ListView.builder(
                              itemCount: 4,
                              shrinkWrap: true,
                              scrollDirection: Axis.horizontal,
                              itemBuilder: (context, index) {
                                return Padding(
                                  padding: REdgeInsets.only(right: 20),
                                  child: GestureDetector(
                                    onTap: () {
                                      notifier.changeCalendarType(
                                        index: index,
                                        context: context,
                                      );
                                      //   Navigator.pop(context);
                                    },
                                    child: Column(
                                      children: [
                                        AbsorbPointer(
                                          child: CircleButton(
                                            size: 44,
                                            borderColor:
                                                state.calendarType == index
                                                    ? Style.primary
                                                    : Style.colorGrey,
                                            backgroundColor:
                                                state.calendarType == index
                                                    ? Style.primary
                                                    : Style.greyColor,
                                            iconColor:
                                                state.calendarType == index
                                                    ? Style.white
                                                    : Style.black,
                                            icon: index == 0
                                                ? Icons.view_day_outlined
                                                : index == 1
                                                    ? Icons
                                                        .width_normal_outlined
                                                    : index == 2
                                                        ? Icons
                                                            .calendar_view_week
                                                        : Icons.list,
                                            onTap: () {},
                                          ),
                                        ),
                                        8.verticalSpace,
                                        Text(
                                          AppHelpers.getTranslation(
                                            index == 0
                                                ? TrKeys.day
                                                : index == 1
                                                    ? TrKeys.threeDays
                                                    : index == 2
                                                        ? TrKeys.week
                                                        : TrKeys.list,
                                          ),
                                          style: Style.interNormal(size: 15),
                                          maxLines: 1,
                                        ),
                                      ],
                                    ),
                                  ),
                                );
                              })),
                    ),
                    12.horizontalSpace,
                    CustomRefresher(
                      onTap: () {
                        notifier.fetchBookings(
                          context: context,
                          isRefresh: true,
                        );
                        notifier.refresh();
                      },
                      isLoading: state.isLoading,
                    ),
                    24.horizontalSpace,
                    state.calendarType == 3
                        ? SizedBox.shrink()
                        : LoginButton(
                            bgColor: Style.black,
                            icon: Icon(
                              Remix.add_circle_line,
                              color: Style.white,
                              size: 20,
                            ),
                            title: TrKeys.createBooking,
                            onPressed: () => notifier.changeStateIndex(1),
                          ),
                    IconButton(
                      onPressed: () {
                        AppHelpers.showCustomDialog(
                          context: context,
                          title: TrKeys.changeZoom,
                          child: const ZoomModal(),
                        );
                      },
                      icon: const Icon(
                        Icons.zoom_out_map,
                        color: Style.primary,
                      ),
                    ),
                    12.horizontalSpace,
                  ],
                ),
              ),
        Expanded(
          child: state.calendarType == 0
              ? DayView(
                  startDuration: Duration(hours: DateTime.now().hour - 1),
                  showHalfHours: true,
                  heightPerMinute: state.calendarZoom,
                  onDateTap: (s) {},
                  onDateLongPress: (s) {},
                  onPageChange: (s, i) {
                    notifier.changeDate(context, startDate: s);
                  },
                  minuteSlotSize: MinuteSlotSize.minutes5,
                  timeLineWidth: 48.w,
                  isLoading: state.isLoading,
                )
              : state.calendarType == 1
                  ? ThreeDayView(
                      startDuration: Duration(hours: DateTime.now().hour - 1),
                      showHalfHours: true,
                      heightPerMinute: state.calendarZoom,
                      onDateTap: (s) {},
                      onDateLongPress: (s) {},
                      onPageChange: (s, i) {
                        notifier.changeDate(context, startDate: s);
                      },
                      minuteSlotSize: MinuteSlotSize.minutes5,
                      timeLineWidth: 48.w,
                      isLoading: state.isLoading,
                    )
                  : state.calendarType == 2
                      ? WeekView(
                          startDuration:
                              Duration(hours: DateTime.now().hour - 1),
                          showHalfHours: true,
                          heightPerMinute: state.calendarZoom,
                          onDateTap: (s) {},
                          onDateLongPress: (s) {},
                          onPageChange: (s, i) {
                            notifier.changeDate(context, startDate: s);
                          },
                          minuteSlotSize: MinuteSlotSize.minutes5,
                          timeLineWidth: 48.w,
                          isLoading: state.isLoading,
                        )
                      : const BookingTable(),
        )
      ],
    );
  }
}
